<?php
session_start();
require_once '../config/db.php';
require_once '../auth/auth.php';

requireLogin();
header('Content-Type: application/json');

$q = isset($_GET['q']) ? trim($_GET['q']) : '';

try {
    $sql = "
        SELECT 
            i.*, 
            c.name as customer_name, 
            c.email as customer_email, 
            c.phone as customer_phone, 
            u.username as created_by_name,
            COALESCE(q.quote_number, '') as quotation_reference,
            COALESCE(SUM(p.amount), 0) as total_paid
        FROM invoices i
        LEFT JOIN customers c ON i.customer_id = c.id
        JOIN users u ON i.created_by = u.id
        LEFT JOIN quotations q ON i.quotation_id = q.id
        LEFT JOIN payments p ON i.id = p.invoice_id
        WHERE 1=1
        GROUP BY i.id
    ";
    $params = [];
    if ($q !== '') {
        $sql .= " AND (
            i.invoice_number LIKE ? OR
            c.name LIKE ? OR
            i.status LIKE ?
        )";
        $params[] = "%$q%";
        $params[] = "%$q%";
        $params[] = "%$q%";
    }
    $sql .= " ORDER BY i.created_at DESC LIMIT 50";
    $stmt = $pdo->prepare($sql);
    $stmt->execute($params);
    $invoices = $stmt->fetchAll(PDO::FETCH_ASSOC);
    echo json_encode(['success' => true, 'invoices' => $invoices]);
} catch (Exception $e) {
    echo json_encode(['success' => false, 'error' => $e->getMessage()]);
} 